/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.cim.provider.pi.PIHscProviderConstants;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCecInterfaceImplLimits;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspCodeUpdateCmds {
    private static final String START_CODE_UPDATE = "START_CODE_UPDATE";
    private static final String CODE_UPDATE_COMPLETE = "CODE_UPDATE_COMPLETE";
    private static final String CODE_COMMIT = "CODE_COMMIT";
    private static final String REBOOT_SERVICE_PROCESSOR = "REBOOT_SERVICE_PROCESSOR";
    private static final String DELETE_LID = "DELETE_LID";
    private static final String SET_CODE_UPDATE_POLICY = "SET_CODE_UPDATE_POLICY";
    private static final String WRITE_LID = "WRITE_LID";
    private static final String WRITE_LID_OFFSET_IO_DATA = "WRITE_LID_OFFSET_IO_DATA";
    private static final String WRITE_LID_PARTIAL = "WRITE_LID_PARTIAL";
    private static final String READ_LID = "READ_LID";
    private static final String READ_LID_PARTIAL = "READ_LID_PARTIAL";
    private static final String GET_CODE_UPDATE_STATUS = "GET_CODE_UPDATE_STATUS";
    private static final String READ_LID_SPECIAL = "READ_LID_SPECIAL";
    private static final String OPEN_PHYP_FILE = "OPEN_PHYP_FILE";
    private static final String WRITE_PHYP_FILE = "WRITE_PHYP_FILE";
    private static final String CLOSE_PHYP_FILE = "CLOSE_PHYP_FILE";
    private static final String GET_FIRMWARE_UPDATE_STATUS = "GET_FIRMWARE_UPDATE_STATUS";
    private static final String START_FIRMWARE_UPDATE = "START_FIRMWARE_UPDATE";
    private static final String MAX_WRITE_BLOCK_SIZE = "MAX_WRITE_BLOCK_SIZE";
    private static final String LENGTH_WRITTEN = "LENGTH_WRITTEN";
    private static final String END_OF_FILE_FLAG = "END_OF_FILE_FLAG";
    private static final String LENGTH_READ = "LENGTH_READ";
    private static final String DATA = "DATA";
    private static final short EOF_FLAG = 128;
    private static final String ERROR_TYPE = "ERROR_TYPE";
    private static final long MAX_READ_BLOCKS = 65536L;
    private static final int DEFAULT_TIMEOUT = 180000;
    private static FspCodeUpdateCmds mInst;

    private FspCodeUpdateCmds() {
    }

    static FspCodeUpdateCmds getInstance() {
        if (mInst == null) {
            mInst = new FspCodeUpdateCmds();
        }
        return mInst;
    }

    public static long startCodeUpdateCmd(FSPCmdMgr fSPCmdMgr, String string, UnsignedInt8 unsignedInt8, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        long l = 0L;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.startCodeUpdateCmd");
        try {
            hashtable = fSPCmdMgr.doFSPCommand(START_CODE_UPDATE, new String[]{unsignedInt8.toString(), unsignedInt16.toString()}, 0, null, 1, string);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            n = pIHscCmdMgrException.getStatus();
            Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.startCodeUpdateCmd");
            HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
            if (n == 192) {
                throw new PIHscServerException("3351", pIHscCmdMgrException);
            }
            if (n == 193) {
                throw new PIHscServerException("3352", pIHscCmdMgrException);
            }
            if (n == 194) {
                throw new PIHscServerException("3353", pIHscCmdMgrException);
            }
            if (n == 203) {
                throw new PIHscServerException("3354", pIHscCmdMgrException);
            }
            if (n == 3) {
                throw new PIHscServerException("3377", pIHscCmdMgrException);
            }
            if (n == 25) {
                throw new PIHscServerException("3378", pIHscCmdMgrException);
            }
            if (n == 252) {
                throw new PIHscServerException("3379", pIHscCmdMgrException);
            }
            throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
        }
        l = ((UnsignedInt32)hashtable.get(MAX_WRITE_BLOCK_SIZE)).intValue();
        Trace.trace("apcuhscF", "The Max write block size FSPClient is :" + l);
        System.out.println("The Max write block size FSPClient is :" + l);
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.startCodeUpdateCmd");
        return l;
    }

    public static void completeCodeUpdateCmd(FSPCmdMgr fSPCmdMgr, String string, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.completeCodeUpdateCmd");
        try {
            hashtable = fSPCmdMgr.doFSPCommand(CODE_UPDATE_COMPLETE, new String[]{unsignedInt8.toString()}, 0, null, 1, string);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
            Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.completeCodeUpdateCmd");
            n = pIHscCmdMgrException.getStatus();
            if (n == 195) {
                throw new PIHscServerException("3351", pIHscCmdMgrException);
            }
            if (n == 3) {
                throw new PIHscServerException("3381", pIHscCmdMgrException);
            }
            if (n == 251) {
                throw new PIHscServerException("3383", pIHscCmdMgrException);
            }
            if (n == 254) {
                throw new PIHscServerException("3360", pIHscCmdMgrException);
            }
            if (n == 25) {
                throw new PIHscServerException("3378", pIHscCmdMgrException);
            }
            throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
        }
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.completeCodeUpdateCmd");
    }

    public static void commitCodeCmd(FSPCmdMgr fSPCmdMgr, String string, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        int n2 = 1800000;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.commitCodeCmd");
        try {
            hashtable = fSPCmdMgr.doFSPCommand(CODE_COMMIT, new String[]{unsignedInt8.toString()}, n2, null, 1, string);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
            Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.commitCodeCmd");
            n = pIHscCmdMgrException.getStatus();
            if (n == 193) {
                throw new PIHscServerException("3352", pIHscCmdMgrException);
            }
            if (n == 194) {
                throw new PIHscServerException("3353", pIHscCmdMgrException);
            }
            if (n == 204) {
                throw new PIHscServerException("3357", pIHscCmdMgrException);
            }
            if (n == 254) {
                throw new PIHscServerException("3360", pIHscCmdMgrException);
            }
            throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
        }
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.commitCodeCmd");
    }

    public static void rebootSPCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.rebootSPCmd");
        hashtable = fSPCmdMgr.doFSPCommand(REBOOT_SERVICE_PROCESSOR, null, 0, null, 1, string);
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.rebootSPCmd");
    }

    public static void deleteLIDCmd(FSPCmdMgr fSPCmdMgr, String string, UnsignedInt32 unsignedInt32) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.deleteLIDCmd");
        try {
            hashtable = fSPCmdMgr.doFSPCommand(DELETE_LID, new String[]{unsignedInt32.toString()}, 0, null, 1, string);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.deleteLIDCmd");
            HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
            n = pIHscCmdMgrException.getStatus();
            if (n == 195) {
                throw new PIHscServerException("3356", pIHscCmdMgrException);
            }
            if (n == 204) {
                throw new PIHscServerException("3357", pIHscCmdMgrException);
            }
            if (n == 205) {
                throw new PIHscServerException("3358", pIHscCmdMgrException);
            }
            if (n == 254) {
                throw new PIHscServerException("3360", pIHscCmdMgrException);
            }
            throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
        }
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.deleteLIDCmd");
    }

    public static void setCodeUpdatePolicyCmd(FSPCmdMgr fSPCmdMgr, String string, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.setCodeUpdatePolicyCmd");
        try {
            hashtable = fSPCmdMgr.doFSPCommand(SET_CODE_UPDATE_POLICY, new String[]{unsignedInt8.toString()}, 0, null, 1, string);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            n = pIHscCmdMgrException.getStatus();
            Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.setCodeUpdatePolicyCmd");
            if (n == 193) {
                throw new PIHscServerException("3352", pIHscCmdMgrException);
            }
            if (n == 80) {
                throw new PIHscServerException("3352", pIHscCmdMgrException);
            }
            throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
        }
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.setCodeUpdatePolicyCmd");
    }

    public static void writeLIDCmd(FSPCmdMgr fSPCmdMgr, String string, File file, UnsignedInt32 unsignedInt32, long l) throws PIHscServerException, IOException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        boolean bl = false;
        long l2 = 0L;
        int n2 = 1;
        long l3 = 0L;
        long l4 = file.length();
        short s = 0;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.writeLIDCmd");
        System.out.println("IN WRITE-LID");
        System.out.println("The LID number is :" + unsignedInt32);
        System.out.println("The file is :" + file);
        System.out.println("The length of the file is :" + l4);
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        System.out.println("The max write block size is : " + l);
        long l5 = l - 50L;
        System.out.println("The write block size is :" + l5);
        long l6 = l4 % l5;
        n2 = l4 > l5 && l6 != 0L ? (int)(l4 / l5 + 1L) : (l6 == 0L ? (int)(l4 / l5) : 1);
        l3 = 0L;
        for (int i = 0; i < n2; ++i) {
            long l7 = 0L;
            l7 = i != n2 - 1 || l6 == 0L ? l5 : l6;
            System.out.println("offset in write LID = " + l3);
            System.out.println("dataLen in write LID = " + l7);
            s = n2 == 1 ? (short)192 : (i == 0 ? (short)128 : (i == n2 - 1 ? (short)64 : 0));
            System.out.println("Flag in write LID = " + s);
            long l8 = System.currentTimeMillis();
            byte[] byArray = new byte[(int)l7];
            bufferedInputStream.read(byArray, 0, byArray.length);
            long l9 = System.currentTimeMillis();
            System.out.println("Time taken to do the read from the file : " + (l9 - l8) / 1000L);
            String string2 = ByteUtilities.toHexString(byArray);
            System.out.println("hexstring.length = " + string2.length());
            l8 = System.currentTimeMillis();
            try {
                hashtable = fSPCmdMgr.doFSPCommand(WRITE_LID, new String[]{Long.toString(20L), Short.toString(s), unsignedInt32.toString(), Long.toString(l3), Long.toString(l7), string2}, 180000, null, 1, string);
                l9 = System.currentTimeMillis();
                System.out.println("Time taken to send and receive the command from FSP : " + (l9 - l8) / 1000L);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.writeLIDCmd");
                n = pIHscCmdMgrException.getStatus();
                System.out.println("The error status value is :" + n);
                if (n == 195) {
                    throw new PIHscServerException("3356", pIHscCmdMgrException);
                }
                if (n == 80) {
                    throw new PIHscServerException("3359", pIHscCmdMgrException);
                }
                if (n == 204) {
                    throw new PIHscServerException("3357", pIHscCmdMgrException);
                }
                if (n == 254) {
                    throw new PIHscServerException("3360", pIHscCmdMgrException);
                }
                throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
            }
            l3 += l7;
        }
        bufferedInputStream.close();
        fileInputStream.close();
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.writeLIDCmd");
    }

    public static void writeLIDPartialCmd(FSPCmdMgr fSPCmdMgr, String string, File file, UnsignedInt8 unsignedInt8, UnsignedInt32 unsignedInt32, long l) throws PIHscServerException, IOException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        boolean bl = false;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n2 = 1;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = file.length();
        boolean bl2 = false;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.writeLIDPartialCmd");
        System.out.println("In WRITE LID Partial");
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        long l8 = FspCodeUpdateCmds.getMaxCommandSize(fSPCmdMgr);
        long l9 = l8 - 50L;
        long l10 = l7 % l9;
        Trace.trace("apcuhscF", "The code side is :" + unsignedInt8);
        Trace.trace("apcuhscF", "The maxSize is = " + l8);
        Trace.trace("apcuhscF", "The actual size in writelidpartial is:" + l9);
        System.out.println("The code side is :" + unsignedInt8);
        System.out.println("maxSize = " + l8);
        System.out.println("The actual size in writelidpartial is:" + l9);
        n2 = l7 > l9 && l10 != 0L ? (int)(l7 / l9 + 1L) : (l10 == 0L ? (int)(l7 / l9) : 1);
        l5 = 0L;
        l6 = l;
        for (int i = 0; i < n2; ++i) {
            long l11 = 0L;
            l11 = i != n2 - 1 || l10 == 0L ? l9 : l10;
            Trace.trace("apcuhscF", "The offset in write LID = " + l5);
            Trace.trace("apcuhscF", "The dataLen in write LID = " + l11);
            System.out.println("offset in write LID = " + l5);
            System.out.println("dataLen in write LID = " + l11);
            byte[] byArray = new byte[(int)l11];
            bufferedInputStream.read(byArray, 0, byArray.length);
            String string2 = ByteUtilities.toHexString(byArray);
            System.out.println("hexstring.length = " + string2.length());
            try {
                hashtable = fSPCmdMgr.doFSPCommand(WRITE_LID_PARTIAL, new String[]{Long.toString(16L), unsignedInt32.toString(), Long.toString(l6), Long.toString(l11), unsignedInt8.toString(), string2}, 0, null, 1, string);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.writeLIDPartialCmd");
                n = pIHscCmdMgrException.getStatus();
                if (n == 195) {
                    throw new PIHscServerException("3356", pIHscCmdMgrException);
                }
                if (n == 80) {
                    throw new PIHscServerException("3356", pIHscCmdMgrException);
                }
                if (n == 204) {
                    throw new PIHscServerException("3357", pIHscCmdMgrException);
                }
                if (n == 254) {
                    throw new PIHscServerException("3360", pIHscCmdMgrException);
                }
                if (n == 203) {
                    throw new PIHscServerException("3354", pIHscCmdMgrException);
                }
                throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
            }
            l6 += l11;
        }
        bufferedInputStream.close();
        fileInputStream.close();
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.writeLIDPartialCmd");
    }

    public static void readLIDCmd(FSPCmdMgr fSPCmdMgr, String string, File file, UnsignedInt32 unsignedInt32) throws PIHscServerException, IOException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        short s = 0;
        int n2 = 0;
        byte[] byArray = new byte[]{};
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        System.out.println("In READ LID");
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.readLIDCmd");
        fileOutputStream = new FileOutputStream(file);
        bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        long l4 = FspCodeUpdateCmds.getMaxCommandSize(fSPCmdMgr);
        long l5 = 65486L;
        Trace.trace("apcuhscF", "The maxSize = " + l4);
        Trace.trace("apcuhscF", "The LID Number is :" + unsignedInt32);
        Trace.trace("apcuhscF", "The actual size to read is :" + l5);
        System.out.println("maxSize = " + l4);
        System.out.println("The LID Number is :" + unsignedInt32);
        System.out.println("The actual size to read is :" + l5);
        long l6 = 0L;
        l6 = l5;
        while (bl) {
            try {
                hashtable = fSPCmdMgr.doFSPCommand(READ_LID, new String[]{unsignedInt32.toString(), Long.toString(l3), Long.toString(l6)}, 180000, null, 1, string);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                n = pIHscCmdMgrException.getStatus();
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readLIDCmd");
                if (n == 80) {
                    throw new PIHscServerException("3359", pIHscCmdMgrException);
                }
                if (n == 203) {
                    throw new PIHscServerException("3354", pIHscCmdMgrException);
                }
                if (n == 254) {
                    throw new PIHscServerException("3360", pIHscCmdMgrException);
                }
                throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
            }
            s = ((UnsignedInt8)hashtable.get(END_OF_FILE_FLAG)).shortValue();
            if (3 <= Trace.LEVEL) {
                Trace.trace("apcuhscD", "The end of flag is :" + s);
                Trace.trace("apcuhscD", "The lenght read after the read lid is :" + l2);
            }
            System.out.println("The end of flag is :" + s);
            l2 = ((UnsignedInt32)hashtable.get(LENGTH_READ)).longValue();
            System.out.println("The lenght read after the read lid is :" + l2);
            byte[] byArray2 = (byte[])hashtable.get(DATA);
            System.out.println("The lenght of the array in tmp is " + byArray2.length);
            byArray = ByteUtilities.byteCat(byArray, byArray2);
            System.out.println("The counter value is : " + ++n2);
            if (n2 == 50 || (s & 0x80) == 128) {
                System.out.println("Either counter is 50 or the end of file flag has reached");
                try {
                    System.out.println("Writing data to buffer");
                    bufferedOutputStream.write(byArray, 0, byArray.length);
                    byArray = new byte[]{};
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    HSCLogUtils.serverLog(iOException, HSCLogUtils._CECClassLogInfo);
                    throw new PIHscServerException("3386", iOException);
                }
                n2 = 0;
            }
            if ((s & 0x80) == 128) {
                System.out.println("Setting the flag to false");
                bl = false;
            }
            l3 += l2;
        }
        bufferedOutputStream.flush();
        fileOutputStream.flush();
        fileOutputStream.close();
        bufferedOutputStream.close();
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readLIDCmd");
    }

    public static void readPartialLIDCmd(FSPCmdMgr fSPCmdMgr, String string, File file, UnsignedInt32 unsignedInt32, long l, long l2) throws PIHscServerException, IOException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        boolean bl = false;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        short s = 0;
        byte[] byArray = new byte[]{};
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        System.out.println("In READ Partial LID");
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.readPartialLIDCmd");
        fileOutputStream = new FileOutputStream(file);
        bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        long l7 = FspCodeUpdateCmds.getMaxCommandSize(fSPCmdMgr);
        Trace.trace("apcuhscF", "The maxSize is = " + l7);
        System.out.println("maxSize = " + l7);
        long l8 = l7 - 50L;
        Trace.trace("apcuhscF", "The actual write size is :" + l8);
        System.out.println(" The actual write size is :" + l8);
        int n2 = 1;
        long l9 = l2 % l8;
        System.out.println("The mod value is :" + l9);
        n2 = l2 > l8 && l9 != 0L ? (int)(l2 / l8 + 1L) : (l9 == 0L ? (int)(l2 / l8) : 1);
        l5 = l;
        for (int i = 0; i < n2; ++i) {
            long l10 = 0L;
            l10 = i != n2 - 1 || l9 == 0L ? l8 : l9;
            try {
                hashtable = fSPCmdMgr.doFSPCommand(READ_LID_PARTIAL, new String[]{unsignedInt32.toString(), Long.toString(l5), Long.toString(l10)}, 0, null, 1, string);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                n = pIHscCmdMgrException.getStatus();
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readPartialLIDCmd");
                if (n == 80) {
                    throw new PIHscServerException("3359", pIHscCmdMgrException);
                }
                if (n == 203) {
                    throw new PIHscServerException("3354", pIHscCmdMgrException);
                }
                if (n == 254) {
                    throw new PIHscServerException("3360", pIHscCmdMgrException);
                }
                if (n == 204) {
                    throw new PIHscServerException("3357", pIHscCmdMgrException);
                }
                throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
            }
            s = ((UnsignedInt8)hashtable.get(END_OF_FILE_FLAG)).shortValue();
            l4 = ((UnsignedInt32)hashtable.get(LENGTH_READ)).longValue();
            Trace.trace("apcuhscF", "The eof flag :" + s);
            Trace.trace("apcuhscF", "The actual lenght read :" + l4);
            System.out.println("The eof flag :" + s);
            System.out.println("The actual lenght read :" + l4);
            byte[] byArray2 = (byte[])hashtable.get(DATA);
            System.out.println("The lenght of the array in tmp is " + byArray2.length);
            try {
                System.out.println("The offset is :" + l5);
                bufferedOutputStream.write(byArray2, 0, byArray2.length);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                HSCLogUtils.serverLog(iOException, HSCLogUtils._CECClassLogInfo);
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readPartialLIDCmd");
                throw new PIHscServerException("3386", iOException);
            }
            if ((s & 0x80) == 128 && i != n2 - 1) {
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readPartialLIDCmd");
                throw new PIHscServerException("3384", null);
            }
            l5 += l4;
            l6 += l4;
            l3 += l4;
        }
        bufferedOutputStream.flush();
        fileOutputStream.flush();
        fileOutputStream.close();
        bufferedOutputStream.close();
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readPartialLIDCmd");
    }

    public static Hashtable getCodeUpdateStatusCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.getCodeUpdateStatusCmd");
        hashtable = fSPCmdMgr.doFSPCommand(GET_CODE_UPDATE_STATUS, null, 0, null, 1, string);
        n = (Integer)hashtable.get(ERROR_TYPE);
        if (n != 0) {
            System.out.println("Get Code Update Status failed, error code " + n);
        }
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.getCodeUpdateStatusCmd");
        return hashtable;
    }

    public static void readSpecialLIDCmd(FSPCmdMgr fSPCmdMgr, String string, File file, UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8, long l, long l2) throws PIHscServerException, IOException, PIHscCmdMgrException {
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.readSpecialLIDCmd");
        if (l2 == 0L) {
            FspCodeUpdateCmds.readFully(fSPCmdMgr, file, unsignedInt16, unsignedInt8, string);
        } else {
            FspCodeUpdateCmds.readPartial(fSPCmdMgr, file, unsignedInt16, unsignedInt8, l, l2, string);
        }
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readSpecialLIDCmd");
    }

    public static void readFully(FSPCmdMgr fSPCmdMgr, File file, UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8, String string) throws PIHscServerException, IOException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        short s = 0;
        byte[] byArray = new byte[]{};
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.readFully");
        System.out.println("In read fully for special read");
        System.out.println("The lid file name is :" + unsignedInt16);
        fileOutputStream = new FileOutputStream(file);
        bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        long l4 = FspCodeUpdateCmds.getMaxCommandSize(fSPCmdMgr);
        System.out.println("maxSize = " + l4);
        long l5 = l4 - 50L;
        long l6 = 0L;
        l6 = l5;
        while (bl) {
            try {
                hashtable = fSPCmdMgr.doFSPCommand(READ_LID_SPECIAL, new String[]{unsignedInt16.toString(), unsignedInt8.toString(), Long.toString(l3), Long.toString(l6)}, 0, null, 1, string);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                n = pIHscCmdMgrException.getStatus();
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readFully");
                if (n == 80) {
                    throw new PIHscServerException("3359", pIHscCmdMgrException);
                }
                if (n == 203) {
                    throw new PIHscServerException("3354", pIHscCmdMgrException);
                }
                if (n == 254) {
                    throw new PIHscServerException("3360", pIHscCmdMgrException);
                }
                throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
            }
            s = ((UnsignedInt8)hashtable.get(END_OF_FILE_FLAG)).shortValue();
            l2 = ((UnsignedInt32)hashtable.get(LENGTH_READ)).longValue();
            Trace.trace("apcuhscF", "The lenght read after the read lid is :" + l2);
            System.out.println("The lenght read after the read lid is :" + l2);
            byte[] byArray2 = (byte[])hashtable.get(DATA);
            System.out.println("The lenght of the array in tmp is " + byArray2.length);
            System.out.println("The lenght of the array in data is " + byArray.length);
            try {
                bufferedOutputStream.write(byArray2, 0, byArray2.length);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                HSCLogUtils.serverLog(iOException, HSCLogUtils._CECClassLogInfo);
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readFully");
                throw new PIHscServerException("3386", iOException);
            }
            if ((s & 0x80) == 128) {
                bl = false;
            }
            l3 += l2;
        }
        bufferedOutputStream.flush();
        fileOutputStream.flush();
        fileOutputStream.close();
        bufferedOutputStream.close();
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readFully");
    }

    public static void readPartial(FSPCmdMgr fSPCmdMgr, File file, UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8, long l, long l2, String string) throws PIHscServerException, IOException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        boolean bl = false;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        short s = 0;
        byte[] byArray = new byte[]{};
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.readPartial");
        System.out.println("In read partial for spcecial read");
        System.out.println("The lenght to read is :" + l2);
        fileOutputStream = new FileOutputStream(file);
        bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        long l7 = FspCodeUpdateCmds.getMaxCommandSize(fSPCmdMgr);
        System.out.println("maxSize = " + l7);
        long l8 = l7 - 50L;
        int n2 = 1;
        long l9 = l2 % l8;
        n2 = l2 > l8 && l9 != 0L ? (int)(l2 / l8 + 1L) : (l9 == 0L ? (int)(l2 / l8) : 1);
        Trace.trace("apcuhscF", "The number of times is :" + n2);
        System.out.println("The number of times is :" + n2);
        l5 = l;
        for (int i = 0; i < n2; ++i) {
            long l10 = 0L;
            l10 = i != n2 - 1 || l9 == 0L ? l8 : l9;
            Trace.trace("apcuhscF", "The offset RLP value is :" + l5);
            Trace.trace("apcuhscF", "The lenght RLP to read is :" + l10);
            System.out.println("The offset RLP value is :" + l5);
            System.out.println("The lenght RLP to read is :" + l10);
            try {
                hashtable = fSPCmdMgr.doFSPCommand(READ_LID_SPECIAL, new String[]{unsignedInt16.toString(), unsignedInt8.toString(), Long.toString(l5), Long.toString(l10)}, 0, null, 1, string);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                n = pIHscCmdMgrException.getStatus();
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readPartial");
                if (n == 80) {
                    throw new PIHscServerException("3359", pIHscCmdMgrException);
                }
                if (n == 203) {
                    throw new PIHscServerException("3354", pIHscCmdMgrException);
                }
                if (n == 254) {
                    throw new PIHscServerException("3360", pIHscCmdMgrException);
                }
                if (n == 204) {
                    throw new PIHscServerException("3357", pIHscCmdMgrException);
                }
                throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
            }
            s = ((UnsignedInt8)hashtable.get(END_OF_FILE_FLAG)).shortValue();
            l4 = ((UnsignedInt32)hashtable.get(LENGTH_READ)).longValue();
            Trace.trace("apcuhscF", "The eof flag :" + s);
            Trace.trace("apcuhscF", "The actial lenght read :" + l4);
            System.out.println("The eof flag :" + s);
            System.out.println("The actial lenght read :" + l4);
            byte[] byArray2 = (byte[])hashtable.get(DATA);
            System.out.println("The lenght of the array in tmp is " + byArray2.length);
            try {
                System.out.println("The offset is :" + l5);
                bufferedOutputStream.write(byArray2, 0, byArray2.length);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                HSCLogUtils.serverLog(iOException, HSCLogUtils._CECClassLogInfo);
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readPartial");
                throw new PIHscServerException("3386", iOException);
            }
            if ((s & 0x80) == 128 && i != n2 - 1) {
                bufferedOutputStream.flush();
                fileOutputStream.flush();
                fileOutputStream.close();
                bufferedOutputStream.close();
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readPartial");
                throw new PIHscServerException("3384", null);
            }
            l5 += l4;
            l6 += l4;
            l3 += l4;
        }
        bufferedOutputStream.flush();
        fileOutputStream.flush();
        fileOutputStream.close();
        bufferedOutputStream.close();
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.readPartial");
    }

    public static Hashtable openPhypFileCmd(FSPCmdMgr fSPCmdMgr, String string, UnsignedInt16 unsignedInt16, UnsignedInt32 unsignedInt32, UnsignedInt8 unsignedInt8, UnsignedInt8 unsignedInt82, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.openPhypFileCmd");
        System.out.println("In OPEN PHYP FILE");
        hashtable = fSPCmdMgr.doPhypCommand(OPEN_PHYP_FILE, new String[]{unsignedInt16.toString(), unsignedInt32.toString(), unsignedInt8.toString(), unsignedInt82.toString(), unsignedInt322.toString(), unsignedInt323.toString()});
        n = (Integer)hashtable.get(ERROR_TYPE);
        if (n != 0) {
            System.out.println("Open phyp file failed, error code " + n);
        }
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.openPhypFileCmd");
        return hashtable;
    }

    public static Hashtable closePhypFileCmd(FSPCmdMgr fSPCmdMgr, String string, UnsignedInt16 unsignedInt16, UnsignedInt32 unsignedInt32, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.closePhypFileCmd");
        System.out.println("In CLOSE PHYP FILE");
        hashtable = fSPCmdMgr.doPhypCommand(CLOSE_PHYP_FILE, new String[]{unsignedInt16.toString(), unsignedInt32.toString(), unsignedInt8.toString()});
        n = (Integer)hashtable.get(ERROR_TYPE);
        if (n != 0) {
            System.out.println("Open phyp file failed, error code " + n);
        }
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.closePhypFileCmd");
        return hashtable;
    }

    public static UnsignedInt16 writePhypFileCmd(FSPCmdMgr fSPCmdMgr, String string, UnsignedInt16 unsignedInt16, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, File file) throws PIHscServerException, IOException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        int n2 = 1;
        long l3 = file.length();
        boolean bl2 = false;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.writePhypFileCmd");
        System.out.println("In write PHYP FILE ******************");
        System.out.println("The lenght of the file is :" + l3);
        l = 0L;
        long l4 = unsignedInt322.longValue();
        Trace.trace("apcuhscF", "The lenght of the file is :" + (l3 -= l4));
        Trace.trace("apcuhscF", "The write size is :" + unsignedInt323.longValue());
        System.out.println("The lenght of the file is :" + l3);
        System.out.println("The write size is :" + unsignedInt323.longValue());
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        long l5 = unsignedInt323.longValue() - 50L;
        long l6 = l3 % l5;
        n2 = l3 > l5 && l6 != 0L ? (int)(l3 / l5 + 1L) : (l6 == 0L ? (int)(l3 / l5) : 1);
        System.out.println("The number of times is :" + n2);
        if (l4 != 0L) {
            long l7 = bufferedInputStream.skip(l4);
            System.out.println("The skiped value is :" + l7);
        }
        for (int i = 0; i < n2; ++i) {
            long l8 = 0L;
            l8 = i != n2 - 1 || l6 == 0L ? l5 : l6;
            System.out.println("dataLen in write LID = " + l8);
            byte[] byArray = new byte[(int)l8];
            bufferedInputStream.read(byArray, 0, byArray.length);
            String string2 = ByteUtilities.toHexString(byArray);
            System.out.println("hexstring.length = " + string2.length());
            try {
                hashtable = fSPCmdMgr.doPhypCommand(WRITE_PHYP_FILE, new String[]{unsignedInt16.toString(), unsignedInt32.toString(), Long.toString(l), Long.toString(l8), string2});
                UnsignedInt16 unsignedInt162 = (UnsignedInt16)hashtable.get("RETURN_CODE");
                System.out.println("The return code is : " + unsignedInt162);
                if (!unsignedInt162.equals((Object)PIHscProviderConstants.IO_CON_MAIN_SUCCESS)) {
                    System.out.println("Unsuccessful return code- hence returning");
                    Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.writePhypFileCmd");
                    return unsignedInt162;
                }
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                n = pIHscCmdMgrException.getStatus();
                Trace.trace("apcuhscF", "The error status value is :" + n);
                Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.writePhypFileCmd");
                System.out.println("The error status value is :" + n);
                throw new PIHscServerException("3355", new String[]{Integer.toHexString(n)}, pIHscCmdMgrException);
            }
            l2 = ((UnsignedInt32)hashtable.get(LENGTH_WRITTEN)).longValue();
            Trace.trace("apcuhscF", "The actualLen Written is : " + l2);
            System.out.println("The actualLen Written is : " + l2);
            Trace.trace("apcuhscF", "The offset to write is :" + (l += l2));
            System.out.println("The offset to write is :" + l);
        }
        bufferedInputStream.close();
        fileInputStream.close();
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.writePhypFileCmd");
        return PIHscProviderConstants.IO_CON_MAIN_SUCCESS;
    }

    public static Hashtable getPhypUpdateStatusCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.getPhypUpdateStatusCmd");
        System.out.println("In Get PHYP update status");
        hashtable = fSPCmdMgr.doPhypCommand(GET_FIRMWARE_UPDATE_STATUS, null);
        n = (Integer)hashtable.get(ERROR_TYPE);
        if (n != 0) {
            System.out.println("Get Code Update Status failed, error code " + n);
        }
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.getPhypUpdateStatusCmd");
        return hashtable;
    }

    public static Hashtable startFirmwareUpdateCmd(FSPCmdMgr fSPCmdMgr, String string, UnsignedInt8 unsignedInt8, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        int n = 0;
        Trace.trace("apcuhscT", "-> FspCodeUpdateCmds.startFirmwareUpdateCmd");
        System.out.println("In start firmware update");
        hashtable = fSPCmdMgr.doPhypCommand(START_FIRMWARE_UPDATE, new String[]{unsignedInt8.toString(), unsignedInt16.toString()});
        n = (Integer)hashtable.get(ERROR_TYPE);
        if (n != 0) {
            System.out.println("Get Code Update Status failed, error code " + n);
        }
        Trace.trace("apcuhscT", "<- FspCodeUpdateCmds.startFirmwareUpdateCmd");
        return hashtable;
    }

    private static int getMaxCommandSize(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        FspCecInterfaceImplLimits fspCecInterfaceImplLimits = fSPCmdMgr.getInterfaceLimits();
        return fspCecInterfaceImplLimits.getMaxCommandSize().intValue();
    }
}

